<?php
function loadfiles()
{
  wp_enqueue_style('owl.carousel', get_template_directory_uri() . '/assets/css/owl.carousel.min.css', false);
  wp_enqueue_style('bootstrap-rtl', 'https://cdn.rtlcss.com/bootstrap/v4.2.1/css/bootstrap.min.css', false);
  wp_enqueue_style('style', get_template_directory_uri() . '/assets/css/style.min.css', false, null);
  wp_enqueue_style('Responsive', get_template_directory_uri() . '/assets/css/Responsive.min.css', false, null);
  wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/fontawesome/css/all.min.css', false, null);
}
function rpthem_enqueue_script()
{

  wp_enqueue_script('barsa', get_template_directory_uri() . '/assets/js/barsa.min.js', array(), '1.0', 'true');
  wp_enqueue_script('ajax', 'https://ajax.googleapis.com/ajax/libs/jquery/3.4.1/jquery.min.js', '1.0', 'true');
  wp_enqueue_script('fontawesome', 'https://kit.fontawesome.com/2b7aba1fa2.js', '1.0', 'true');
  wp_enqueue_script('sticky-sidebar', 'https://cdnjs.cloudflare.com/ajax/libs/sticky-sidebar/3.3.1/sticky-sidebar.min.js', '1.0');
  wp_enqueue_script('owl.carousel', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js', '1.0', 'true');
  wp_enqueue_script('theme-theme', get_template_directory_uri(), array('js-cookie'), 'true');
  wp_enqueue_script('read-more', get_template_directory_uri() . '/assets/js/read-more.min.js', array(), '1.0', 'true');
  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
}
add_action('wp_enqueue_scripts', 'rpthem_enqueue_script');
add_action('wp_enqueue_scripts', 'loadfiles');
// add defer js file

// Update js within in Admin
function custom_admin_js()
{
  $url = esc_url(get_template_directory_uri()) . '/js/wp-admin.js';
  echo '"<script type="text/javascript" src="' . $url . '"></script>"';
  wp_enqueue_script('admin', get_template_directory_uri() . '/assets/admin/js/admin.min.js', array(), '1.0', 'true');
}
add_action('admin_footer', 'custom_admin_js');
// Update CSS within in Admin
function admin_style()
{
  wp_enqueue_style('admin-styles', get_template_directory_uri() . '/assets/admin/css/admin.min.css');
}
add_action('admin_enqueue_scripts', 'admin_style');
// register menus
function configmenus()
{
  register_nav_menus(
    array(
      'main-menu' => __(' main menu', 'liosa'),
      'main-menu-mobile' => __('Menu Mobile', 'liosa'),
      'hashtag-menu' => __('hashtag menu ', 'liosa'),
      'footer-menu' => __('Footer menu ', 'liosa'),
      'menu-bar-head' => __('menu bar', 'liosa'),
      'menu-bar-head2' => __('menu bar 2', 'liosa'),
    )
  );
}
add_action('init', 'configmenus');
// register sidebar
function widgetregister()
{
  if (function_exists('register_sidebar'))
    register_sidebar(array(
      'name'          => __('left sidebar', 'liosa'),
      'id'            => 'leftsidebar',
      'before_widget' => '<div class="sidebar-area">',
      'after_widget'  => '</div>',
      'before_title'  => '<h4 class="side-title"><span>',
      'after_title'   => '</span></h4>',
    ));
  register_sidebar(array(
    'name'          => __('right sidebar', 'liosa'),
    'id'            => 'rightsidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('download sidebar', 'liosa'),
    'id'            => 'downloadsidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('page sidebar', 'liosa'),
    'id'            => 'pagesidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('page sidebar left', 'liosa'),
    'id'            => 'pageleftsidebar',
    'before_widget' => '<div class="sidebar-area">',
    'after_widget'  => '</div>',
    'before_title'  => '<h4 class="side-title"><span>',
    'after_title'   => '</span></h4>',
  ));
  register_sidebar(array(
    'name'          => __('First column footer', 'liosa'),
    'id'            => 'footerone',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
  register_sidebar(array(
    'name'          => __('Second column footer', 'liosa'),
    'id'            => 'footertwo',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
  register_sidebar(array(
    'name'          => __('Third column footer', 'liosa'),
    'id'            => 'footerthree',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
  register_sidebar(array(
    'name'          => __('fourth column footer', 'liosa'),
    'id'            => 'footerfour',
    'before_widget' => '',
    'after_widget'  => '',
    'before_title'  => '<h5 class="title-section">',
    'after_title'   => '</h5>',
  ));
}
add_action('widgets_init', 'widgetregister');
// post readmore
function new_excerpt_more($more)
{
  global $post;
  return '<span class="post-readmore"><a target="_blank" class="post-readmore" href="' . get_permalink($post->ID) . '"> ادامه مطلب</a></span></p>';
}
function custom_excerpt_length($length)
{
  return 35;
}
add_filter('excerpt_more', 'new_excerpt_more');
// locate template
add_filter('excerpt_length', 'custom_excerpt_length', 999);
locate_template('includes/framework/widgets/widget-ads.php',      true, true);
locate_template('includes/framework/widgets/widget-posts.php',    true, true);
locate_template('includes/framework/widgets/widget-video.php',    true, true);
locate_template('includes/metabox/version-down.php',              true, true);
locate_template('includes/metabox/select-header.php',              true, true);
if (!isset($content_width)) $content_width = 618;
require_once(get_template_directory() . '/includes/framework/functions/theme-functions.php');
require_once(get_template_directory() . '/includes/custom-search.php');
require_once(get_template_directory() . '/includes/framework/widgets/sid-single-shop.php');
require_once(get_template_directory() . '/includes/css.php');
require_once(get_template_directory() . '/includes/breadcrumbs.php');
require_once(get_template_directory() . '/includes/elementor/elementor.php');
// load theme textdomain
load_theme_textdomain('liosa', get_template_directory() . '/language');
// add mega menu for elementor
require_once(get_template_directory() . '/includes/mega-menu/admin/class-admin-assets.php');
require_once(get_template_directory() . '/includes/mega-menu/admin/class-admin.php');
require_once(get_template_directory() . '/includes/mega-menu/class-menu-item-post-type.php');
require_once(get_template_directory() . '/includes/mega-menu/class-menu-walker.php');
require_once(get_template_directory() . '/includes/mega-menu/core-functions.php');
require_once(get_template_directory() . '/includes/mega-menu/hook-functions.php');
require_once(get_template_directory() . '/themeplat/user/profile-edit-user.php');
// img responsive
function img_responsive($content)
{
  return str_replace('<img class="', '<img class="img-responsive ', $content);
}
add_filter('the_content', 'img_responsive');
/*
 * Set post views count using post meta
 */
function getPostViews($postID)
{
  $count_key = 'post_views_count';
  $count = get_post_meta($postID, $count_key, true);
  if ($count == '') {
    delete_post_meta($postID, $count_key);
    add_post_meta($postID, $count_key, '0');
    return "0 بازدید";
  }
  return $count . ' بازدید';
}
function setPostViews($postID)
{
  $count_key = 'post_views_count';
  $count = get_post_meta($postID, $count_key, true);
  if ($count == '') {
    $count = 0;
    delete_post_meta($postID, $count_key);
    add_post_meta($postID, $count_key, '0');
  } else {
    $count++;
    update_post_meta($postID, $count_key, $count);
  }
}
remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
/*
add theme support woocommerce
*/
add_action('after_setup_theme', 'woocommerce_support');
function woocommerce_support()
{
  add_theme_support('woocommerce');
  add_theme_support('wc-product-gallery-zoom');
  add_theme_support('wc-product-gallery-lightbox');
  add_theme_support('wc-product-gallery-slider');
}
//comment
function mytheme_comment($comment, $args, $depth)
{
  if ('div' === $args['style']) {
    $tag       = 'div';
    $add_below = 'comment';
  } else {
    $tag       = 'li';
    $add_below = 'div-comment';
  } ?>
  <<?php echo $tag; ?> <?php comment_class(empty($args['has_children']) ? '' : 'parent'); ?> id="comment-<?php comment_ID() ?>"><?php
                                                                                                                                if ('div' != $args['style']) { ?>
      <div id="div-comment-<?php comment_ID() ?>" class="comment-body"><?php
                                                                                                                                } ?>
      <div class="comment-author vcard"><?php
                                        if ($args['avatar_size'] != 0) {
                                          echo get_avatar($comment, $args['avatar_size']);
                                        }
                                        printf(__('<cite class="fn">%s</cite> <span class="says-comment">says:</span>', 'liosa'), get_comment_author_link()); ?>
      </div><?php
            if ($comment->comment_approved == '0') { ?>
        <em class="comment-awaiting-moderation"><?php esc_html__('Your comment is awaiting moderation.', 'liosa'); ?></em><br /><?php
                                                                                                                              } ?>
      <div class="comment-meta commentmetadata">
        <a href="<?php echo htmlspecialchars(get_comment_link($comment->comment_ID)); ?>"><?php
                                                                                          /* translators: 1: date, 2: time */
                                                                                          printf(
                                                                                            __('%1$s at %2$s', 'liosa'),
                                                                                            get_comment_date(),
                                                                                            get_comment_time()
                                                                                          ); ?>
        </a><?php
            edit_comment_link(__('(Edit)', 'liosa'), '  ', ''); ?>
      </div>

      <?php comment_text(); ?>

      <div class="reply"><?php
                          comment_reply_link(
                            array_merge(
                              $args,
                              array(
                                'add_below' => $add_below,
                                'depth'     => $depth,
                                'max_depth' => $args['max_depth']
                              )
                            )
                          ); ?>
      </div><?php
            if ('div' != $args['style']) : ?>
      </div><?php
            endif;
          }
          add_theme_support('post-thumbnails');
          if (function_exists('add_image_size')) {
            add_image_size('thumb1', 300, false);
          }
          /* ----------------------------------------------------------------------- comment -----------------*/

          add_action('wp_enqueue_scripts', 'misha_ajax_comments_scripts');

          function misha_ajax_comments_scripts()
          {

            // I think jQuery is already included in your theme, check it yourself
            wp_enqueue_script('jquery');

            // just register for now, we will enqueue it below
            wp_register_script('ajax_comment', get_stylesheet_directory_uri() . '/assets/js/ajax-comment.min.js', array('jquery'), 'true');

            // let's pass ajaxurl here, you can do it directly in JavaScript but sometimes it can cause problems, so better is PHP
            wp_localize_script('ajax_comment', 'misha_ajax_comment_params', array(
              'ajaxurl' => site_url() . '/wp-admin/admin-ajax.php'
            ));

            wp_enqueue_script('ajax_comment');
          }
          add_action('wp_ajax_ajaxcomments', 'misha_submit_ajax_comment'); // wp_ajax_{action} for registered user
          add_action('wp_ajax_nopriv_ajaxcomments', 'misha_submit_ajax_comment'); // wp_ajax_nopriv_{action} for not registered users

          function misha_submit_ajax_comment()
          {
            $comment = wp_handle_comment_submission(wp_unslash($_POST));
            if (is_wp_error($comment)) {
              $error_data = intval($comment->get_error_data());
              if (!empty($error_data)) {
                wp_die('<p>' . $comment->get_error_message() . '</p>', __('Comment Submission Failure', 'liosa'), array('response' => $error_data, 'back_link' => true));
              } else {
                wp_die('Unknown error');
              }
            }
            $user = wp_get_current_user();
            do_action('set_comment_cookies', $comment, $user);
            $comment_depth = 1;
            $comment_parent = $comment->comment_parent;
            while ($comment_parent) {
              $comment_depth++;
              $parent_comment = get_comment($comment_parent);
              $comment_parent = $parent_comment->comment_parent;
            }
            $GLOBALS['comment'] = $comment;
            $GLOBALS['comment_depth'] = $comment_depth;
            $comment_html = '<li ' . comment_class('', null, null, false) . ' id="comment-' . get_comment_ID() . '">
		<article class="comment-body" id="div-comment-' . get_comment_ID() . '">
    <div class="apply_comment-user">
    <div class="comment-content">' . apply_filters('comment_text', get_comment_text($comment), $comment) . '</div>
			<footer class="comment-meta" style="margin-bottom:1rem;">
				<div class="comment-metadata">
					<a href="' . esc_url(get_comment_link($comment->comment_ID)) . '">' . sprintf(_x('%s پیش', '%s = human-readable time difference', 'liosa'), human_time_diff(get_comment_time('U'), current_time('timestamp'))) . '</a>';

            if ($edit_link = get_edit_comment_link())
              $comment_html .= '<span class="edit-link"><a class="comment-edit-link" href="' . $edit_link . '">ویرایش</a></span>';

            $comment_html .= '</div>';
            if ($comment->comment_approved == '0')
              $comment_html .= '<p class="comment-awaiting-moderation">نظر شما در انتظار تایید است.</p>';

            $comment_html .= '</footer></div>
		</article>
	</li>';
            echo $comment_html;

            die();
          }
          /*------------------------------------------------------------------------ TIME POSTS -----------------------------------*/
          function days_ago()
          {
            $days = round((date('U') - get_the_time('U')) / (60 * 60 * 24));
            if ($days == 0) {
              echo "امروز";
            } elseif ($days == 1) {
              echo "دیروز";
            } else {
              echo "" . $days . " روز پیش";
            }
          }
          /* ------------------------------------------------------------------------- post views count panl worpress ------------*/
          function set_post_view_custom_field()
          {
            if (is_single()) {
              global $post;
              $post_id = $post->ID;
              $count = 1;
              $post_view_count = get_post_meta($post_id, 'post_view_count', true);
              if ($post_view_count) {
                $count = $post_view_count + 1;
              }
              update_post_meta($post_id, 'post_view_count', $count);
            }
          }
          add_action('wp_head', 'set_post_view_custom_field');
          function add_post_view_count_column($columns)
          {
            if (is_array($columns) && !isset($columns['post_view_count']))
              $columns['post_view_count'] = 'تعداد بازدید';
            return $columns;
          }
          add_filter('manage_posts_columns', 'add_post_view_count_column');
          function set_post_view_count_column($column_name, $post_ID)
          {
            if ($column_name == 'post_view_count') {
              $count = get_post_meta($post_ID, 'post_view_count', true);
              echo $count ? $count : 0;
            }
          }
          add_action('manage_posts_custom_column', 'set_post_view_count_column', 10, 2);
          /* ------------------------------------------------------------------------- post views count single ------------*/
          function get_post_view_count($post_id)
          {
            return get_post_meta($post_id, 'post_view_count', true);
          }
          /* ------------------------------------------------------------------------- thumbnails size ------------*/
          add_theme_support('post-thumbnails');
          if (function_exists('add_image_size')) {
            add_image_size('singlethumbnail', 900, false);
            add_image_size('singlenavigation', 50, 50, true);
            add_image_size('singledown', 200, false);
            add_image_size('thumb4', 1400, false);
            add_image_size('thumb5', 300, false);
          }
          /* -------------------------------------------------------css----------------------------------------------------------*/
          function add_css_advan()
          {
            if (ot_get_option('add_css_advan', false) != false) {
              echo '<style>' . ot_get_option('add_css_advan') . '</style>';
            }
          }
          add_action('wp_head', 'add_css_advan', 100);
          /* ------------------------------------------------------------------------- posts_per_page  ------------*/
          function wpdocs_five_posts_on_homepage($query)
          {
            if ($query->is_home() && $query->is_main_query()) {
              $query->set('posts_per_page', ot_get_option('item_arcive_blog'));
            }
          }
          add_action('pre_get_posts', 'wpdocs_five_posts_on_homepage');

          /* ------------------------------------------------------------------------- option tree ------------*/
          add_filter('ot_theme_mode', '__return_true');
          add_filter('ot_show_pages', '__return_false');
          require(trailingslashit(get_template_directory()) . 'option-tree/ot-loader.php');
          require(trailingslashit(get_template_directory()) . 'includes/theme-options.php');
          //The below code is to shift the price
          function ts_shuffle_variable_product_elements()
          {
            if (is_product()) {
              global $post;
              $product = wc_get_product($post->ID);
              if ($product->is_type('variable')) {
                remove_action('woocommerce_single_variation', 'woocommerce_single_variation', 10);
                add_action('woocommerce_before_variations_form', 'woocommerce_single_variation', 20);

                remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_title', 5);
                add_action('woocommerce_before_variations_form', 'woocommerce_template_single_title', 10);

                remove_action('woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20);
                add_action('woocommerce_before_variations_form', 'woocommerce_template_single_excerpt', 30);
              }
            }
          }
          add_action('woocommerce_before_single_product', 'ts_shuffle_variable_product_elements');
          //display active uploads svg
          function add_file_types_to_uploads($file_types)
          {
            $new_filetypes = array();
            $new_filetypes['svg'] = 'image/svg+xml';
            $file_types = array_merge($file_types, $new_filetypes);
            return $file_types;
          }
          add_filter('upload_mimes', 'add_file_types_to_uploads');
          function wpb_remove_version()
          {
            return '';
          }
          add_filter('the_generator', 'wpb_remove_version');
          function comicpress_copyright()
          {
            global $wpdb;
            $copyright_dates = $wpdb->get_results("
      SELECT
      YEAR(min(post_date_gmt)) AS firstdate,
      YEAR(max(post_date_gmt)) AS lastdate
      FROM
      $wpdb->posts
      WHERE
      post_status = 'publish'
      ");
            $output = '';
            if ($copyright_dates) {
              $copyright = " © " . $copyright_dates[0]->firstdate;
              if ($copyright_dates[0]->firstdate != $copyright_dates[0]->lastdate) {
                $copyright .= '-' . $copyright_dates[0]->lastdate;
              }
              $output = $copyright;
            }
            return $output;
          }
          remove_action('woocommerce_archive_description', 'woocommerce_taxonomy_archive_description', 10);
          function cat_cart_count($cat_name)
          {
            $count = 0; // Initializing
            foreach (WC()->cart->get_cart() as $cart_item) {
              if (has_term($term, 'product_cat', $cart_item['product_id']))
                $count += $cart_item['quantity'];
            }
            return $count == 0 ? false : $count;
          }

          add_filter('woocommerce_single_product_carousel_options', 'sf_update_woo_flexslider_options');
          function sf_update_woo_flexslider_options($options)
          {
            $options['directionNav'] = true;
            return $options;
          }
          function first_paragraph($content)
          {
            return preg_replace('/<p([^>]+)?>/', '<p$1 class="intro">', $content, 1);
          }
          add_filter('the_content', 'first_paragraph');

          if (is_404()) :
            get_header('home');
          endif;
          /* ------------------------------------------------------- Plugin Activation ----------------------------------------------------------*/
          require_once dirname(__FILE__) . '/includes/activation.php';

          add_action('tgmpa_register', 'my_theme_register_required_plugins');

          function my_theme_register_required_plugins()
          {

            $plugins = array(
              array(
                'name'      => 'Elementor',
                'slug'      => 'elementor',
                'required'  => true,
              ),
            );

            $config = array(
              'id'           => 'tgmpa',
              'default_path' => '',
              'menu'         => 'tgmpa-install-plugins',
              'parent_slug'  => 'themes.php',
              'capability'   => 'edit_theme_options',
              'has_notices'  => true,
              'dismissable'  => true,
              'dismiss_msg'  => '',
              'is_automatic' => false,
              'message'      => '',
            );

            tgmpa($plugins, $config);
          }
          /**
           * Removes some menus by page.
           */
          function remove_admin_menu_items()
          {
            remove_menu_page('yith_wcwl_panel');
          }
          add_action('admin_menu', 'remove_admin_menu_items', 9999);
          /**
           * contact page
           */
          function wpschool_contact_scripts()
          {
            wp_register_script('ajax-contact-script', get_template_directory_uri() . '/assets/js/ajax-contact-script.js', array('jquery'));
            wp_enqueue_script('ajax-contact-script');

            wp_localize_script('ajax-contact-script', 'ajax_contact_object', array(
              'ajax_url' => admin_url('admin-ajax.php'),
              'loading_message' => esc_html__('در حال ارسال اطلاعات ، لطفا صبر کنید...', 'liosa')
            ));
          }
          add_action('wp_enqueue_scripts', 'wpschool_contact_scripts');

          function wpschool_ajax_contact()
          {
            $hasError = false;
            if (trim($_POST['contactName']) === '') {
              $message = 'لطفا نام خود را وارد نمایید';
              $hasError = true;
            } else {
              $name =  sanitize_text_field($_POST['contactName']);
            }
            if (trim($_POST['email']) === '') {
              $message = 'لطفا آدرس ایمیل خود را وارد نمایید.';
              $hasError = true;
            } else if (!preg_match("/^[[:alnum:]][a-z0-9_.-]*@[a-z0-9.-]+\.[a-z]{2,4}$/i", trim($_POST['email']))) {
              $message = 'آدرس ایمیل وارد شده صحیح نمی باشد';
              $hasError = true;
            } else {
              $email =  sanitize_text_field($_POST['email']);
            }
            if (trim($_POST['commentsText']) === '') {
              $message = 'لطفا پیام خود را وارد نمایید';
              $hasError = true;
            } else {
              $comments = esc_textarea($_POST['commentsText']);
            }
            if (!$hasError) {
              $emailTo = get_option('admin_email');
              $subject = 'یک پیغام از طرف ' . $name;
              $body = "نام فرستنده: $name \n\nایمیل نویسنده: $email \n\nپیغام: $comments";
              $headers = 'From: ' . $name . ' <contact@wpsho.com> ' . "\r\n" . 'Reply-To: ' . $email;
              wp_mail($emailTo, $subject, $body, $headers);
              $message = esc_html__('پیام شما با موفقیت ارسال شد، با تشکر از شما', 'liosa');
            }
            echo json_encode(array('error' => $hasError, 'message' => $message));
            die();
          }
          add_action('wp_ajax_wpschool_ajax_contact', 'wpschool_ajax_contact');
          add_action('wp_ajax_nopriv_wpschool_ajax_contact', 'wpschool_ajax_contact');
          /**
           * Remove the breadcrumbs 
           */
          add_action('init', 'woo_remove_wc_breadcrumbs');
          function woo_remove_wc_breadcrumbs()
          {
            remove_action('woocommerce_before_main_content', 'woocommerce_breadcrumb', 20, 0);
          }
          /* upload img profil */
          add_action('woocommerce_before_edit_account_form', 'wc_cus_cpp_form');
          function wc_cus_cpp_form($atts, $content = NULL)
          {

            $user_id = get_current_user_id();

            if (isset($_GET['action']) && $_GET['action'] == 'delete') {
              $picture_id = get_user_meta($user_id, 'profile_pic', true);
              delete_user_meta($user_id, 'profile_pic');
              wp_delete_post($picture_id, true);
            }
            if ($_FILES and trim($_FILES['profile_pic']['name']) != '') {
              $picture_id = wc_cus_upload_picture($_FILES['profile_pic']);
              wc_cus_save_profile_pic($picture_id, $user_id);
            }
            $picture_id = get_user_meta($user_id, 'profile_pic', true);

            if (trim($picture_id) == '') :
              $delete_link = '';
            else :
              $delete_link = '<a href="' . get_permalink(get_option('woocommerce_myaccount_page_id')) . '/edit-account/?action=delete">حذف</a>';
            endif;
            echo '<div class="wc_cus_cpp_form">';
            echo get_avatar($user_id) . '<br>';
            echo '</div>';
            echo '<label class="label_getFile" for="getFile">تصویر پروفایل</label>';
            echo '<div class="form_group_profile_pic">';
            echo $delete_link;
            echo '
        <form enctype="multipart/form-data" action="" method="POST">
        <label for="choose-file" class="custom-file-upload" id="choose-file-label">
          انتخاب تصویر
        </label>
        <input  name="profile_pic" size="25" type="file" id="choose-file" 
        accept=".jpg,.jpeg,.pdf,doc,docx,application/msword,.png" style="display: none;" />
        <input class="form_sub" value="جایگذاری" type="submit">
        </form>
    ';
            echo '</div>';
          }
          function wc_cus_save_profile_pic($picture_id, $user_id)
          {
            update_user_meta($user_id, 'profile_pic', $picture_id);
          }
          function wc_cus_upload_picture($foto)
          {
            $wordpress_upload_dir = wp_upload_dir();
            $i = 1; // number of tries when the file with the same name is already exists
            $profilepicture = $foto;
            $new_file_path = $wordpress_upload_dir['path'] . '/' . $profilepicture['name'];
            $check = getimagesize($profilepicture['tmp_name']);
            $new_file_mime = $check["mime"];

            $log = new WC_Logger();

            if (empty($profilepicture))
              $log->add('custom_profile_picture', 'File is not selected.');
            if ($profilepicture['error'])
              $log->add('custom_profile_picture', $profilepicture['error']);

            if ($profilepicture['size'] > wp_max_upload_size())
              $log->add('custom_profile_picture', 'It is too large than expected.');

            if (!in_array($new_file_mime, get_allowed_mime_types()))
              $log->add('custom_profile_picture', 'WordPress doesn\'t allow this type of uploads.');
            while (file_exists($new_file_path)) {
              $i++;
              $new_file_path = $wordpress_upload_dir['path'] . '/' . $i . '_' . $profilepicture['name'];
            }
            // looks like everything is OK
            if (move_uploaded_file($profilepicture['tmp_name'], $new_file_path)) {

              $upload_id = wp_insert_attachment(array(
                'guid'           => $new_file_path,
                'post_mime_type' => $new_file_mime,
                'post_content'   => '',
                'post_status'    => 'inherit'
              ), $new_file_path);

              require_once(str_replace(esc_url(home_url()) . '/', ABSPATH, get_admin_url()) . 'includes/image.php');
              wp_update_attachment_metadata($upload_id, wp_generate_attachment_metadata($upload_id, $new_file_path));
              return $upload_id;
            }
          }
          add_filter('get_avatar', 'wc_cus_change_avatar', 1, 5);
          function wc_cus_change_avatar($avatar, $id_or_email, $size, $default, $alt)
          {
            $user = false;
            if (is_numeric($id_or_email)) {
              $id = (int) $id_or_email;
              $user = get_user_by('id', $id);
            } elseif (is_object($id_or_email)) {
              if (!empty($id_or_email->user_id)) {
                $id = (int) $id_or_email->user_id;
                $user = get_user_by('id', $id);
              }
            } else {
              $user = get_user_by('email', $id_or_email);
            }
            if ($user && is_object($user)) {
              $picture_id = get_user_meta($user->data->ID, 'profile_pic');
              if (!empty($picture_id)) {
                $avatar = wp_get_attachment_url($picture_id[0]);
                $avatar = "<img alt='{$alt}' src='{$avatar}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}' />";
              }
            }
            return $avatar;
          }
          add_action('after_setup_theme', 'wpse_theme_setup');
          function wpse_theme_setup()
          {
            add_theme_support('title-tag');
          }
          /* add fild user social */
          function thewebsitedev_user_social_links($user_contact)
          {
            $user_contact['facebook'] = __('Facebook Link', 'topaz');
            $user_contact['twitter'] = __('Twitter Link', 'topaz');
            $user_contact['dribbble'] = __('Dribbble Link', 'topaz');
            $user_contact['instagram'] = __('instagram Link', 'topaz');
            $user_contact['pinterest'] = __('Pinterest Link', 'topaz');
            $user_contact['linkedin'] = __('LinkedIn Link', 'topaz');
            $user_contact['googleplus'] = __('Google+ Link', 'topaz');
            return $user_contact;
          }
          add_filter('user_contactmethods', 'thewebsitedev_user_social_links');
          // Function to return user count
          function a4fran3_user_count()
          {
            $usercount = count_users();
            $result = $usercount['total_users'];
            return $result;
          }
          add_shortcode('number_users', 'a4fran3_user_count');
          /* Set post views count , Display Popular Posts By Views*/
          function shapeSpace_popular_posts($post_id)
          {
            $count_key = 'popular_posts';
            $count = get_post_meta($post_id, $count_key, true);
            if ($count == '') {
              $count = 0;
              delete_post_meta($post_id, $count_key);
              add_post_meta($post_id, $count_key, '0');
            } else {
              $count++;
              update_post_meta($post_id, $count_key, $count);
            }
          }
          function shapeSpace_track_posts($post_id)
          {
            if (!is_single()) return;
            if (empty($post_id)) {
              global $post;
              $post_id = $post->ID;
            }
            shapeSpace_popular_posts($post_id);
          }
          add_action('wp_head', 'shapeSpace_track_posts');
