<div class="Graders-content guttered">
    <section class="solid-home container" style="background:<?php echo $settings['background_Color_vid']; ?>">
        <div class="row">
            <?php
            if ($settings['list']) {
                foreach ($settings['list'] as $item) {
                    if (!empty($item['bg_image']['id'])) {
                        $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['bg_image']['id'], 'bg_image', $item);
                    } elseif (!empty($item['bg_image']['url'])) {
                        $bg_image = $item['bg_image']['url'];
                    }
                    if (empty($bg_image) && 'classic' == $item['skin']) {
                        $print_bg = false;
                    }
                    if (empty($item['title']) && empty($item['description']) && empty($item['button']) && 'none') {
                        $print_content = false;
                    }
                    $this->add_render_attribute('background_image', 'style', [
                        'background-image: url(' . $bg_image . ');',
                    ]);
                    $args = array();
                    $args['post_status'] = 'publish';
                    $args['ignore_sticky_posts'] = 1;
                    if (!empty($item['grid_post_type']) && post_type_exists($item['grid_post_type'])) {
                        $args['post_type'] = $item['grid_post_type'];
                    }
                    if (!empty($item['grid_post_categories']) && $item['grid_post_type'] == 'post') {
                        $args['category_name'] = $item['grid_post_categories'];
                    }
                    if (!empty($item['grid_product_categories']) && $item['grid_post_type'] == 'product') {
                        $args['tax_query'] = array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'field' => 'slug',
                                'terms' => $item['grid_product_categories'],
                            ),
                        );
                    }
                    if (!empty($item['grid_items']) && intval($item['grid_items']) == $item['grid_items']) {
                        $args['posts_per_page'] = $item['grid_items'];
                    }
                    if (!empty($item['grid_order_by'])) {
                        $args['orderby'] = $item['grid_order_by'];
                    }
            ?>
                    <div class="col-12 col-sm-6 col-lg-4">
                        <article class="cat-card verticalarea">
                            <header class="no-padding lazy-hoarea" <?php echo $this->get_render_attribute_string('background_image'); ?>>
                                <div class="ovl overlay-dark"></div>
                                <figure>
                                    <?php
                                    echo '<img class="lazy-hoarea card-thumb" src="' . $item['image']['url'] . '" alt="">';
                                    ?>
                                    <div class="card-title">
                                        <a>
                                            <h5><?php echo '<dt class="elementor-repeater-item-' . $item['_id'] . '">' . $item['list_title'] . '</dt>'; ?></h5>
                                            <i class="fa fa-list-ol" aria-hidden="true"></i>
                                            <?php
                                            $cat = get_category($item['number_post']);
                                            echo $cat->count;
                                            ?><span style="padding-right: 5px;">نوشته</span>
                                        </a>
                                    </div>
                                </figure>
                            </header>
                            <ul>
                                <?php
                                $query = new \WP_Query($args);
                                if ($query->have_posts()) {
                                    while ($query->have_posts()) {
                                        $query->the_post();
                                ?>
                                        <li>
                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                        </li>
                                <?php
                                    }
                                } // end if;
                                ?>
                            </ul>
                            <?php if ('yes' === $item['show_more']) { ?>
                                <footer class="flow-root">
                                    <?php
                                    $target = $item['website_link']['is_external'] ? ' target="_blank"' : '';
                                    $nofollow = $item['website_link']['nofollow'] ? ' rel="nofollow"' : '';
                                    echo '<a class="left" href="' . $item['website_link']['url'] . '"' . $target . $nofollow . '>';
                                    echo $item['title_more'];
                                    ''; ?>
                                    <i class="fa fa-angle-left" aria-hidden="true"></i>
                                    </a>
                                </footer>
                            <?php } ?>
                        </article>
                    </div>
            <?php
                }
            }
            ?>
        </div>
    </section>
</div>