<?php

defined( 'ABSPATH' ) || exit();
function asg_get_megamenu_item_data( $menu_id = false ) { 
	return get_post_meta( $menu_id, 'asg_megamenu_item_data', true );
}

function asg_update_item_data( $menu_id = false, $data = array() ) {
	update_post_meta( $menu_id, 'asg_megamenu_item_data', $data );
	do_action( 'asg_menu_item_updated', $menu_id, $data );
}

function asg_delete_item_data( $menu_id = false ) {
	delete_post_meta( $menu_id, 'asg_megamenu_item_data' );
	do_action( 'asg_megamenu_item_deleted', $menu_id );
}

function asg_get_post_related_menu( $menu_id = false ) {
	$post_id = 0;
	$slug = get_post_meta( $menu_id, 'asgh_elementor_post_name', true );
	if( $slug ){
		$queried_post = get_page_by_path( $slug , OBJECT ,'asgh_menu_item');
		if( isset($queried_post->ID) ){
			$post_id = $queried_post->ID;
		}
	}
	return apply_filters( 'asg_post_related_menu_post_id', $post_id, $menu_id );
}

function asg_create_related_post( $menu_id = false ) {
	$args = apply_filters( 'asg_megamenu_create_related_post_args', array(
			'post_type' 	=> 'asgh_menu_item',
			'post_title' 	=> '#'.$menu_id,
			'post_name'		=> 'megamenu'.$menu_id,
			'post_status' => 'publish'
	) );

	$post_related_id = wp_insert_post( $args );
	// save elementor_post_id meta value
	update_post_meta( $menu_id, 'asgh_elementor_post_id', $post_related_id );
	update_post_meta( $menu_id, 'asgh_elementor_post_name', 'megamenu'.$menu_id );
	// trigger events
	do_action( 'asgh_megamenu_releated_post_created', $post_related_id, $args );
	return apply_filters( 'asgh_megamenu_create_releated_post', $post_related_id );
}
function asg_get_icon_html( $icon = '', $data ) {
	$style = '';
	if( isset($data['icon_color']) && $data['icon_color'] ){
		$style .= 'style="color:'.$data['icon_color'].'"';
	}
	return apply_filters( 'asg_menu_icon_html', '<i class="menu-icon '.$icon.'" '.$style.'></i>' );
}

/**
 * is enabled megamenu
 */
function asg_is_mega_enabled( $menu_item_id = false ) {
	$item_settings = asg_get_megamenu_item_data( $menu_item_id );
	$boolean = isset($item_settings['enabled']) && $item_settings['enabled'];
	return apply_filters( 'asg_megamenu_item_enabled', $boolean );
}

function asg_menu_get_option( $name = '', $default = false ) {
	$name = 'asg_megamenu_' . $name;
	return apply_filters( 'asg_megamenu_option', get_option( $name, $default ) );
}
function asg_get_badge_html( $badge = '', $data ) {
	
	$style = '';
	// echo '<pre>' . print_r( $data ,1 );die;
	if( (isset($data['badge_color']) && $data['badge_color']) ||  (isset($data['badges_bg_color']) && $data['badges_bg_color'])  ){
		$style .= 'style="'; 
		if( $data['badge_color'] ){
			$style .= '	color:'.$data['badge_color'].'; ';
		}
		if( $data['badges_bg_color'] ){
			$style .= '	background-color:'.$data['badges_bg_color'].'; ';
		}
		$style .= ' "';
	}

	$format = '<small class="menu-badge" %2$s>%1$s</small>';
	return sprintf( $format, esc_attr( $badge ), $style );
}
function asg_get_dropdown_arrow_html( $icon = '' ) {
	return apply_filters( 'asgh_menu_dropdown_arrow_icon_format', sprintf( '<i class="asgh-dropdown-arrow fa %s"></i>', esc_attr( $icon ) ) );
}
/**
 * get arrows icons
 */
function asg_get_arrows_icons() {
	return apply_filters( 'asg_arrows_icons', array(
			'fa fa-angle-down',
			'fa fa-angle-double-down',
			'fa fa-arrow-circle-down',
			'fa fa-arrow-down',
			'fa fa-caret-down',
			'fa fa-chevron-circle-down',
			'fa fa-chevron-down',
			'fa fa-long-arrow-down',
			'fa fa-angle-right',
			'fa-angle-double-right',
			'fa-arrow-circle-right',
			'fa-arrow-right',
			'fa-caret-right',
			'fa-chevron-circle-right',
			'fa-chevron-right',
			'fa-long-arrow-right',
			'fa-angle-left',
			'fa-angle-double-left',
			'fa-arrow-circle-left',
			'fa-arrow-left',
			'fa-caret-left',
			'fa-chevron-circle-left',
			'fa-chevron-left',
			'fa-long-arrow-left'
		) );
}

function asg_get_fontawesome_icons() {
	wp_enqueue_style( 'fontawesome','https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css', false, null );
	return \Elementor\Control_Icon::get_icons();

}