<div class="container main-content">
    <div class="module-title">
        <div class="row">
            <div class="col-12">
                <h2 class="color_custom"><span style="color:"><?php echo single_cat_title(''); ?></span></h2>
                <span class="module-title__sep sl_th"></span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-12 col-lg-9 content">
            <div class="topics__content main">
                <section class="topics-gallery root">
                    <div class="row">
                        <?php if (is_category()) : ?>
                            <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                                <div class="topics-gallery__item">
                                    <div class="title-category-header" style="border: 0;">
                                        <h1 class="cb-module-title"><?php echo single_cat_title(''); ?></h1>
                                        <?php the_archive_description('<div class="taxonomy-description">', '</div>'); ?>
                                    </div>
                                </div>
                            </div>
                            <?php
                        endif;
                        if (have_posts()) : while (have_posts()) : the_post(); ?>
                                <div class="col-12 col-sm-6 col-md-4 col-lg-3">
                                    <div class="topics-gallery__item">
                                        <div class="image">
                                            <div class="image__mask"></div>
                                            <a href="<?php the_permalink(); ?>">
                                                <?php
                                                if (has_post_thumbnail()) {
                                                    the_post_thumbnail(array(200, 200), array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
                                                } else { ?>
                                                    <img style="object-fit: cover;" src="<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif" width="200" height="200" alt="<?php _e('Image not found', 'liosa'); ?>" title="<?php _e('Image not found', 'liosa'); ?>">
                                                <?php } ?>
                                            </a>
                                            <?php $category = get_the_category(); ?>
                                            <a href="" title="<?php echo $category[0]->cat_name; ?>" class="image__badge">
                                                <?php echo $category[0]->cat_name; ?>
                                            </a>
                                            <span class="image__fav">
                                                <span class="popularity">
                                                    <span class="popularity__likes">
                                                        <i class="fal fa-heart"></i>
                                                        <span class="popularity__likes--num"></span>
                                                    </span>
                                                    <span class="popularity__time-to-read">
                                                        <?php if (info_content_get_meta('info_content_version')) { ?>
                                                            <i class="fal fa-stopwatch"></i>
                                                            <span class="popularity__minutes-read"><?php echo info_content_get_meta('info_content_version'); ?> مطالعه </span>
                                                        <?php } ?>
                                                    </span>
                                                </span>
                                            </span>
                                        </div>
                                        <a href="<?php the_permalink(); ?>" class="topics-gallery__item__title">
                                            <?php the_title(); ?>
                                        </a>
                                        <div class="item__details">
                                            <div class="user-profile-stat-wrapper">
                                                <?php echo get_avatar(get_the_author_meta('ID'), 32); ?>
                                                <span class="item__details--author"><?php the_author(); ?></span>
                                            </div>
                                            <time class="item__details--date"><i class="fal fa-clock"></i><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile;
                        else : ?>
                            <p><?php _e('Sorry, no posts matched your criteria.', 'liosa'); ?></p>
                        <?php endif; ?>
                        <?php get_template_part('themeplat/content/pagenumbers', 'pagenumbers'); ?>
                    </div>
                </section>
            </div>
        </div>
        <?php get_sidebar('page'); ?>
    </div>
</div>