<?php

/**
 * Elementor Box Content Responsive Widget.
 *
 */

class Dimag_Slid_Box extends \Elementor\Widget_Base
{

  public function get_name()
  {
    return 'dimag-slid-box';
  }

  public function get_title()
  {
    return __('slid box', 'liosa');
  }

  public function get_icon()
  {
    return 'eicon-slider-album';
  }

  public function get_categories()
  {
    return ['elementor-widget-be'];
  }

  private function grid_get_all_post_type_categories($post_type)
  {
    $options = array();

    if ($post_type == 'post') {
      $taxonomy = 'category';
    } else {
      $taxonomy = 'product_cat';
    }

    // Get categories for post type.
    $terms = get_terms(
      array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false,
      )
    );

    foreach ($terms as $term) {
      $options[$term->slug] = $term->name;
    }

    return $options;
  }
  private function grid_get_all_post_types()
  {
    $options = array();
    $exclude = array('attachment', 'elementor_widget_be'); // excluded post types

    $args = array(
      'public' => true,
    );

    foreach (get_post_types($args, 'objects') as $post_type) {

      if (!isset($post_type->name)) {
        continue;
      }

      if (!isset($post_type->label)) {
        continue;
      }

      if (in_array($post_type->name, $exclude) === true) {
        continue;
      }

      $options[$post_type->name] = $post_type->label;
    }

    return $options;
  }



  protected function _register_controls()
  {
    $this->start_controls_section(
      'section_content',
      [
        'label' => __('Content', 'liosa'),
      ]
    );
    $this->add_control(
      'title',
      [
        'label' => __('Title', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    $this->add_control(
      'title_more',
      [
        'label' => __('Title More', 'liosa'),
        'type' => \Elementor\Controls_Manager::TEXT,
      ]
    );
    // Post type.
    $this->add_control(
      'grid_post_type',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-tag"></i> ' . __('Post Type', 'liosa'),
        'default' => 'post',
        'options' => $this->grid_get_all_post_types(),
      ]
    );
    $this->add_control(
      'grid_items',
      [
        'type'        => \Elementor\Controls_Manager::NUMBER,
        'label'       => '<i class="fa fa-th-large"></i> ' . __('Items', 'liosa'),
        'placeholder' => __('How many items?', 'liosa'),
        'default'     => 4,
      ]
    );

    // Post categories.
    $this->add_control(
      'grid_post_categories',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-folder"></i> ' . __('Category', 'liosa'),
        'options' => $this->grid_get_all_post_type_categories('post'),
        'condition' => [
          'grid_post_type' => 'post',
        ],
      ]
    );
    $this->add_control(
      'show_more',
      [
        'label' => __('Show more', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'label_on' => __('Show', 'liosa'),
        'label_off' => __('Hide', 'liosa'),
        'return_value' => 'yes',
        'default' => 'yes',
      ]
    );
    $this->add_control(
      'website_link',
      [
        'label' => __('Link More', 'liosa'),
        'type' => \Elementor\Controls_Manager::URL,
        'placeholder' => __('https://your-link.com', 'liosa'),
        'show_external' => true,
        'default' => [
          'url' => '',
          'is_external' => true,
          'nofollow' => true,
        ],
      ]
    );
    $this->add_control(
      'grid_pagination',
      [
        'label' => '<i class="fa fa-arrow-circle-right"></i> ' . __('Pagination', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => '',
      ]
    );
    // Order by.
    $this->add_control(
      'grid_order_by',
      [
        'type'    => \Elementor\Controls_Manager::SELECT,
        'label'   => '<i class="fa fa-sort"></i> ' . __('Order by', 'liosa'),
        'default' => 'date',
        'options' => [
          'date'          => __('Date', 'liosa'),
          'title'         => __('Title', 'liosa'),
          'modified'      => __('Modified date', 'liosa'),
          'comment_count' => __('Comment count', 'liosa'),
          'rand'          => __('Random', 'liosa'),
        ],
      ]
    );

    // Price.
    $this->add_control(
      'grid_content_price',
      [
        'label' => '<i class="fa fa-usd"></i> ' . __('Price', 'liosa'),
        'type' => \Elementor\Controls_Manager::SWITCHER,
        'default' => 'yes',
        'condition' => [
          'section_grid.grid_post_type' => 'product',
        ],
      ]
    );
    $this->end_controls_section();

    $this->start_controls_section(
      'section_style',
      [
        'label' => __('Style', 'liosa'),
        'tab' => \Elementor\Controls_Manager::TAB_STYLE,
      ]
    );
    $this->add_control(
      'title_color_1',
      [
        'label' => __('Color title', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_2',
      [
        'label' => __('Color show more', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_3',
      [
        'label' => __('background color', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->add_control(
      'title_color_4',
      [
        'label' => __('border color', 'liosa'),
        'type' => \Elementor\Controls_Manager::COLOR,
        'scheme' => [
          'type' => \Elementor\Scheme_Color::get_type(),
          'value' => \Elementor\Scheme_Color::COLOR_1,
        ],
        'selectors' => [
          '{{WRAPPER}} .title' => 'color: {{VALUE}}',
        ],
      ]
    );
    $this->end_controls_section();
  }
  private function grid_pagination_section()
  {
    $this->start_controls_section(
      'section_grid_pagination',
      [
        'label'     => __('Pagination', 'liosa'),
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Pagination alignment.
    $this->add_responsive_control(
      'grid_pagination_alignment',
      [
        'label'     => __('Alignment', 'liosa'),
        'type'      => \Elementor\Controls_Manager::CHOOSE,
        'options'   => [
          'left'    => [
            'title' => __('Left', 'liosa'),
            'icon'  => 'fa fa-align-left',
          ],
          'center'  => [
            'title' => __('Center', 'liosa'),
            'icon'  => 'fa fa-align-center',
          ],
          'right'   => [
            'title' => __('Right', 'liosa'),
            'icon'  => 'fa fa-align-right',
          ],
        ],
        'default'   => 'center',
        'tablet_default'   => 'center',
        'mobile_default'   => 'center',
        'selectors' => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'text-align: {{VALUE}};',
        ],
      ]
    );

    $this->end_controls_section();
  }
  private function grid_pagination_style_section()
  {
    // Tab.
    $this->start_controls_section(
      'section_grid_pagination_style',
      [
        'label' => __('Pagination', 'liosa'),
        'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
        'condition' => [
          'section_grid.grid_pagination' => 'yes',
        ],
      ]
    );

    // Image margin.
    $this->add_control(
      'grid_pagination_style_margin',
      [
        'label'      => __('Margin', 'liosa'),
        'type'       => \Elementor\Controls_Manager::DIMENSIONS,
        'size_units' => ['px'],
        'selectors'  => [
          '{{WRAPPER}} .obfx-grid-pagination .pagination' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
      ]
    );

    $this->end_controls_section();
  }


  protected function render()
  {
    $settings = $this->get_settings(); ?>
    <script>
      $('.owl-two_5.owl-carousel').owlCarousel({
        items: 5,
        rtl: true,
        lazyLoad: true,
        autoWidth: false,
        navText: ['<i class="fal fa-chevron-right"></i>', '<i class="fal fa-chevron-left"></i>'],
        nav: true,
        dots: false,
        autoplay: false,
        loop: true,
        responsive: {
          0: {
            items: 1,
            nav: false,
          },
          600: {
            items: 1,
            nav: false,
          },
          1000: {
            items: 5
          }
        }
      });
    </script>
    <?php
    $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
    $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';
    ?>
    <div class="homepage__main container">
      <style>
        .dimagcarousel,
        .module-title__btn_cla,
        .module-title h2 {
          background-color: <?php echo $settings['title_color_3']; ?>
        }

        .module-title__btn,
        .module-title__sep {
          border-color: <?php echo $settings['title_color_4']; ?>
        }
      </style>
      <section class="dimagcarousel">
        <div class="module-title">
          <div class="row">
            <div class="col-12">
              <h2><span style="color:<?php echo $settings['title_color_1']; ?>"><?php echo $settings['title']; ?></span></h2>
              <span class="module-title__sep"></span>
              <span class="module-title__btn_cla">
                <?php
                if ('yes' === $settings['show_more']) {
                  echo '<a class="module-title__btn" style="color:' . $settings['title_color_2'] . '" href="' . $settings['website_link']['url'] . '"' . $target . $nofollow . '>';
                  echo $settings['title_more'];
                  ''; ?></a>
                <?php } ?>
              </span>
            </div>
          </div>
        </div>
        <section class="owl-two_5 owl-carousel owl-theme">
          <?php
          $args = array();
          $args['post_status'] = 'publish';
          $args['ignore_sticky_posts'] = 1;
          if (!empty($settings['grid_post_type']) && post_type_exists($settings['grid_post_type'])) {
            $args['post_type'] = $settings['grid_post_type'];
          }
          if (!empty($settings['grid_post_categories']) && $settings['grid_post_type'] == 'post') {
            $args['category_name'] = $settings['grid_post_categories'];
          }
          if (!empty($settings['grid_product_categories']) && $settings['grid_post_type'] == 'product') {
            $args['tax_query'] = array(
              'relation' => 'AND',
              array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => $settings['grid_product_categories'],
              ),
            );
          }
          if (!empty($settings['grid_items']) && intval($settings['grid_items']) == $settings['grid_items']) {
            $args['posts_per_page'] = $settings['grid_items'];
          }
          if (!empty($settings['grid_order_by'])) {
            $args['orderby'] = $settings['grid_order_by'];
          }
          if (!empty($settings['grid_pagination'])) {
            $paged         = get_query_var('paged');
            if (empty($paged)) {
              $paged         = get_query_var('page');
            }
            $args['paged'] = $paged;
          }
          $query = new \WP_Query($args);
          if ($query->have_posts()) {
            while ($query->have_posts()) {
              $query->the_post();
          ?>
              <a href="<?php the_permalink(); ?>" class="carousel__body__item">
                <?php
                if (has_post_thumbnail()) {
                  the_post_thumbnail(array(300, 300), array('alt' => '' . get_the_title(), 'title' => '' . get_the_title() . ''));
                } else { ?>
                  <img style="object-fit: cover;" src="<?php print(get_template_directory_uri()); ?>/assets/images/thumb.gif" width="200" height="200" alt="<?php _e('Image not found', 'liosa'); ?>" title="<?php _e('Image not found', 'liosa'); ?>">
                <?php } ?>
                <div class="item__txt">
                  <span><?php the_title(); ?></span>
                </div>
                <div class="item__details">
                  <div class="user-profile-stat-wrapper">
                    <?php echo get_avatar(get_the_author_meta('ID'), 32); ?>
                    <span class="item__details--author"><?php the_author(); ?></span>
                  </div>
                  <time class="item__details--date"><i class="fal fa-clock"></i><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?></time>
                </div>
              </a>
          <?php
            }
          } // end if; 
          ?>
        </section>
      </section>
    </div>
<?php
  }
}
