<div class="container">
    <section class="widget_box_ch_list" style="margin-top:1rem;padding:1rem;background:<?php echo $settings['background_Color_vid']; ?>">
        <?php if ($settings['title']) : ?>
            <header>
                <h3 class="section-heading">
                    <span style="color:<?php echo $settings['text_Color_vid']; ?>">
                        <?php
                        \Elementor\Icons_Manager::render_icon($settings['Iconlayoutvid'], ['aria-hidden' => 'true']);
                        echo $settings['title'];
                        ?>
                    </span>
                </h3>
            </header>
        <?php endif; ?>
        <div class="row">
            <?php
            if ($settings['list']) {
                foreach ($settings['list'] as $item) {
                    if (!empty($item['bg_image']['id'])) {
                        $bg_image = \Elementor\Group_Control_Image_Size::get_attachment_image_src($item['bg_image']['id'], 'bg_image', $item);
                    } elseif (!empty($item['bg_image']['url'])) {
                        $bg_image = $item['bg_image']['url'];
                    }
                    if (empty($bg_image) && 'classic' == $item['skin']) {
                        $print_bg = false;
                    }
                    if (empty($item['title']) && empty($item['description']) && empty($item['button']) && 'none') {
                        $print_content = false;
                    }
                    $this->add_render_attribute('background_image', 'style', [
                        'background-image: url(' . $bg_image . ');',
                    ]);
                    $args = array();
                    $args['post_status'] = 'publish';
                    $args['ignore_sticky_posts'] = 1;
                    if (!empty($item['grid_post_type']) && post_type_exists($item['grid_post_type'])) {
                        $args['post_type'] = $item['grid_post_type'];
                    }
                    if (!empty($item['grid_post_categories']) && $item['grid_post_type'] == 'post') {
                        $args['category_name'] = $item['grid_post_categories'];
                    }
                    if (!empty($item['grid_product_categories']) && $item['grid_post_type'] == 'product') {
                        $args['tax_query'] = array(
                            'relation' => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'field' => 'slug',
                                'terms' => $item['grid_product_categories'],
                            ),
                        );
                    }
                    if (!empty($item['grid_items']) && intval($item['grid_items']) == $item['grid_items']) {
                        $args['posts_per_page'] = $item['grid_items'];
                    }
                    if (!empty($item['grid_order_by'])) {
                        $args['orderby'] = $item['grid_order_by'];
                    }
            ?>
                    <div class="col-12 col-sm-6 col-lg-4">
                        <article class="article_list_posts list_posts_3">
                            <h3 class="section-heading_3" style="border-bottom: 3px solid #9e2358;background:unset;">
                                <span style="color:<?php echo $settings['text_Color_vid']; ?>">
                                    <?php
                                    \Elementor\Icons_Manager::render_icon($item['Iconlayoutvid_list'], ['aria-hidden' => 'true']);
                                    echo '<span class="elementor-repeater-item-' . $item['_id'] . '">' . $item['list_title'] . '</span>';
                                    ?>
                                </span>
                            </h3>
                            <div class="listing_posts">
                                <ul>
                                    <?php
                                    $query = new \WP_Query($args);
                                    if ($query->have_posts()) {
                                        while ($query->have_posts()) {
                                            $query->the_post();
                                            $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(), 'medium_large');

                                    ?>
                                            <li>
                                                <div class="featured">
                                                    <a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" style="background-image: url('<?php echo $thumb['0']; ?>');">
                                                    </a>
                                                </div>
                                                <h3 class="title">
                                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h3>
                                                <div class="post-meta">
                                                    <span class="time">
                                                        <?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش'; ?>
                                                    </span>
                                                </div>
                                            </li>
                                    <?php
                                        }
                                    }
                                    ?>
                                </ul>
                            </div>
                        </article>
                    </div>
            <?php
                }
            }
            ?>
        </div>
    </section>
</div>